reset
set terminal postscript eps color 9 size 3.5,2.5 font 'Helvetica,16'
set out 'utilNSF15.eps'


unset title

set xlabel font 'Helvetica,18'
set ylabel font 'Helvetica,18'
set xlabel 'Traffic Load (Erlangs)'
set ylabel 'Spectrum Utilization Ratio (%)'

set xrange [1.1:2.6] 
set yrange [19:49] 
set key right bottom 
set key font 'Helvetica,16'
set key spacing 1.5
set key samplen 4

set tics nomirror out scale 0.5

	#siatka
set style line 100 lt 1 lc rgb "gray" lw 0.5 
set grid mytics ytics ls 100, ls 100
set grid xtics  ls 100

plot 'spfff5.dat' using 1:($10*100) with line lw 3 lt 2 lc 1 t 'SPF(5)','spfff5.dat' using 1:($10*100):($11*100) with yerrorbars lc 1  lw 2 lt 1 pointtype 0 t'','spfff10.dat' using 1:($10*100) with line lw 3 lt 2 lc 2 t'SPF(10)','spfff10.dat' using 1:($10*100):($11*100) with yerrorbars lc 2  lw 2   lt 1 pointtype 0 t'','spfff15.dat' using 1:($10*100) with line lw 3 lt 3 lc 3 t'SPF(15)','spfff15.dat' using 1:($10*100):($11*100) with yerrorbars lc 3  lw 2   lt 1 pointtype 0 t'','msfff5.dat' using 1:($10*100) with line lw 3 lt 1 lc 'gold' t'MSF(5)','msfff5.dat' using 1:($10*100):($11*100) with yerrorbars lc 'gold' lw 2 lt 1 pointtype 0 t'','modmsfff5.dat' using 1:($10*100) with line lw 3 lt 2 lc 4 t'reMSF(5)','modmsfff5.dat' using 1:($10*100):($11*100) with yerrorbars lc 4  lw 2 lt 1 pointtype 0 t'','lsohff5.dat' using 1:($10*100) with line lw 3 lt 3 lc 7 t 'LSoHF(5)','lsohff5.dat' using 1:($10*100):($11*100) with yerrorbars lc 7 lw 2 lt 1 pointtype 0 t'',
set out

